///////////////////////////////////////////////////////////////////////////////////
//  ASXMLEncoder.h
//    Encode XML. 
//
//  Written by: Acclivity Group LLC 
//
//  Copyright:  (c) 2011-2013 by Acclivity Group LLC, all rights reserved.
//
//  Change History (most recent first): 
//
//  26/04/13  E.J.M.  MayE123. Added m_replaceQuotesAndApos to stop replacement of quotes & apostrophes in xml file for GB.
//  12/13/12  E.J.M.  Added AddChildElementWithTagAndAttribute & StartParentWithTagAndAttribute.
//  08/09/11  S.M.T.  Changed m_lineFeed to CPString to avoid memory problems.
//  05/31/11  S.M.T.  Created file.
//
///////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "ASObject.h"

namespace ASFoundation
{
	class EXTERNAL_API ASXMLEncoder : public ASObject
	{
	public:
		ASXMLEncoder(void);
		ASXMLEncoder(bool bReplaceQuotesAndApos);
		~ASXMLEncoder(void);
		
		// Comments can be added anywhere, but if a document is to be 
		// created with a declaration, the StartDocumentWithDeclaration must
		// be called before adding any other parents or children
		CPError StartDocumentWithDeclarationAndRoot(const CPString xmlDeclaration, const CPString xmlRoot);
		CPError AddComment(const CPString commentString);
		CPError StartParentWithTag(const CPString xmlParentTag);
		CPError EndParentWithTag(const CPString xmlParentTag);
		CPError AddChildElementWithTag(const CPString xmlChildElement, const CPString xmlTag);
		CPError AddChildElementWithTagAndAttribute(const CPString xmlChildElement, const CPString xmlAttribute, const CPString xmlAttributeValue,
													const CPString xmlAttribute1,  const CPString xmlAttributeValue1,const CPString xmlAttribute2,
													const CPString xmlAttributeValue2, const CPString xmlAttribute3, const CPString xmlAttributeValue3,
															const CPString xmlTag);
		CPError StartParentWithTagAndAttribute(const CPString xmlAttribute, const CPString xmlAttributeValue,
															const CPString xmlAttribute1,  const CPString xmlAttributeValue1,
															const CPString xmlAttribute2, const CPString xmlAttributeValue2,
															const CPString xmlAttribute3, const CPString xmlAttributeValue3,
															const CPString xmlTag);
		CPError EndXmlDocument(void);
		CPString GetXmlDocument(void);
		CPError IncrementIndentLevel(void);
		
	private:
		CPString CreateStartTag(const CPString xmlStartTag, bool includeLineFeed);
		CPString CreateEndTag(const CPString xmlEndTag, bool includeIndentLevel);
		CPString CreateCommentStart(void);
		CPString CreateCommentEnd(void);
		CPError AppendToXmlDocument(const CPString xmlString);
		CPError SetXmlEndDeclaration(const CPString xmlString);
		CPString GetXmlEndDeclaration(void);
		CPError DecrementIndentLevel(void);
		int GetIndentLevel(void);
		CPString ReplaceInvalidXmlChars(const CPString xmlString);
		bool GetReplaceQuotesAndApos(void);
		
		int m_IndentLevel;
		bool m_ReplaceQuotesAndApos;
		CPString m_LineFeed;
		CPString m_XMLDocument;
		CPString m_XMLEndRoot;
	};
}
